#include <bits/stdc++.h>
#define ll long long
#define MAXN 305
#define INF ((ll)(1e18))

using namespace std;

struct Ponco
{
  ll w, v;
};

struct Result
{
  ll w, v;
  vector<int> idx;
};

ll N, W;
double E;
Ponco a[MAXN];
Result res[MAXN];

namespace case1
{
  void gen(vector<Ponco> &poncos, vector<Result> &res, int i, int j, ll w, ll v, vector<int> idx)
  {
    if (j == (int)poncos.size())
    {
      res.push_back({w, v, idx});
      return;
    }

    gen(poncos, res, i, j + 1, w, v, idx);
    idx.push_back(i + j);
    gen(poncos, res, i, j + 1, poncos[j].w + w, poncos[j].v + v, idx);
  }

  void clean(vector<Result> &res)
  {
    sort(res.begin(), res.end(), [](Result &a, Result &b)
         {
    if (a.w != b.w) return a.w < b.w;
    return a.v < b.v; });

    int i = 0;
    for (int j = 0; j < (int)res.size(); j++)
    {
      if (res[i].w < res[j].w && res[i].v < res[j].v)
      {
        i++;
        swap(res[i], res[j]);
      }
      else if (res[i].v < res[j].v)
      {
        swap(res[i], res[j]);
      }
    }
    i++;
    res.resize(i);
  }

  vector<int> solve()
  {
    int half = N / 2;
    vector<Ponco> left(a, a + half);
    vector<Ponco> right(a + half, a + N);

    vector<Result> left_res, right_res;
    gen(left, left_res, 0, 0, 0, 0, {});
    gen(right, right_res, half, 0, 0, 0, {});

    clean(left_res);
    clean(right_res);

    ll val = 0;
    vector<int> idx;

    for (int i = 0, j = right_res.size() - 1; i < (int)left_res.size(); i++)
    {
      while (j >= 0 && left_res[i].w + right_res[j].w > W)
      {
        j--;
      }

      if (j >= 0)
      {
        ll sum = left_res[i].v + right_res[j].v;
        if (sum > val)
        {
          val = sum;
          idx = left_res[i].idx;
          idx.insert(idx.end(), right_res[j].idx.begin(), right_res[j].idx.end());
        }
      }
    }

    return idx;
  }
}

namespace case2
{
  vector<int> solve()
  {
    // ll max_v = a[0].v;
    // for (int i = 1; i < N; i++)
    // {
    //   max_v = max(max_v, a[i].v);
    // }

    // double K = (E * max_v) / N;

    // for (int i = 0; i < N; i++)
    // {
    //   a[i].v = (ll)(a[i].v / K);
    // }

    ll sum_v = 0;
    for (int i = 0; i < N; i++)
    {
      sum_v += a[i].v;
    }

    vector<ll> dp(sum_v + 1, INF);
    vector<int> prev_idx(sum_v + 1, -1);
    vector<ll> prev(sum_v + 1, -1);

    dp[0] = 0;

    for (int i = 0; i < N; i++)
    {
      if (a[i].v == 0)
      {
        continue;
      }

      for (int j = sum_v; j >= a[i].v; j--)
      {
        if (dp[j - a[i].v] + a[i].w < dp[j])
        {
          dp[j] = dp[j - a[i].v] + a[i].w;
          prev_idx[j] = i;
          prev[j] = j - a[i].v;
        }
      }
    }

    ll res = 0;
    for (ll v = 0; v <= sum_v; v++)
    {
      if (dp[v] <= W)
      {
        res = v;
      }
    }

    vector<int> idx;
    ll v = res;
    while (v > 0 && prev_idx[v] != -1)
    {
      idx.push_back(prev_idx[v]);
      v = prev[v];
    }

    return idx;
  }
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N >> W >> E;
  for (int i = 0; i < N; i++)
  {
    ll w, v;
    cin >> w >> v;
    a[i] = {w, v};
  }

  vector<int> idx;

  if (N <= 40)
  {
    idx = case1::solve();
  }
  else
  {
    idx = case2::solve();
  }

  cout << idx.size() << "\n";
  for (int i : idx)
  {
    cout << (i + 1) << " ";
  }
  cout << "\n";
}